﻿
using System;
using System.Collections.Generic;
using System.Text;

namespace PI.ZB.N1200.ELearning.BL.DBD.View
{
    internal class StatisticAdvancedLevel : PI.FM.N000.Base.BL.DBD.BaseTable<BO.View.StatisticAdvancedLevel>
    {
        #region Static factory
        private static StatisticAdvancedLevel _factory = null;

        public static StatisticAdvancedLevel DBD
        {
            get
            {
                if (_factory == null)
                {
                    _factory = new StatisticAdvancedLevel();
                }
                return _factory;
            }
        }
        #endregion

        #region Override - Initialization
        protected override void InitializeTableName()
        {
            _tableName = "PIZB1200_AdvancedLevelStatisticView";
        }

        protected override void InitializeProperties()
        {
            Add(new PI.FM.N000.Base.BL.DBD.StringProperty("Name", "Name"));
            Add(new PI.FM.N000.Base.BL.DBD.IntProperty("Count", "Count"));
        }
        #endregion

        #region Commands definition
        public enum Commands
        {
            RestoreBySearch = 20
        }
        #endregion

        #region Get Commands
        protected override Gemini.Core.BL.Interface.DBD.ICommand DoGetCommand(int CommandID)
        {
            switch (CommandID)
            {
                case (int)Commands.RestoreBySearch: return new Command_RestoreBySearch();
            }

            return base.DoGetCommand(CommandID);
        }
        #endregion

        #region Additional Commands Classes
        class Command_RestoreBySearch : PI.FM.N000.Base.BL.DBD.BaseCommand<BO.View.StatisticAdvancedLevel>
        {
            public Command_RestoreBySearch() : base(PI.ZB.N1200.ELearning.BL.DBD.View.StatisticAdvancedLevel.DBD, Gemini.Core.BL.DBD.CommandType.StoredProcedure) { }

            protected override void InitializeParametrs()
            {
                Add(new Gemini.Core.BL.DBD.Param("ClassID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("StudentID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("CompetenceID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("CompetencePartID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
            }

            protected override void InitializeCommandText()
            {
                _commandText = "PIZB1200_AdvancedLevelStatisticView_RestoreBySearch";
            }
        }
        #endregion
    }
}